function [quad,phase] = coupledFM( I_0,g,F_amp,x0,F_angle,x )
%calculate the FM signal of 2 coupled oscillator
%I0: the amplitude prefactor 
%g: the transition linewidth
%x0: the frequency shift
%x: the frequency vector

%Res=0.1;  %resolution of the variable s=kz
%smax=10;  %maximum value of s
wm=9;  %modulation frequency
Z=F_amp*exp(1i*F_angle);
f_0=Z./(2*(x0-x)-1i*g);
f_p=Z./(2*(x0-(x+wm))-1i*g);
f_m=Z./(2*(x0-(x-wm))-1i*g);
% f_0=Z./(x.*(2*(x0-x)-1i*g));
% f_p=Z./((x+wm)*2.*(x0-(x+wm)-1i*g));
% f_m=Z./((x-wm)*2.*(x0-(x-wm)-1i*g));

phase=I_0*real(f_p-f_m);
quad=I_0*imag(f_p+f_m-2*f_0);

% phase=I_0*real(f_0);
% quad=I_0*imag(f_0);
